using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Gumps;
using Server.Misc;
using Server.Network;
using Server.Engines.XmlSpawner2;

namespace Server.Mobiles
{
	//[CorpseName( "Corpse of King!" )]
	public class King : BaseCreature
	{
		public override bool ClickTitle{ get{ return false; } }
		public override bool CanTeach{ get{ return false; } }
		public virtual bool IsInvulnerable { get { return true; } }
		public override bool DisallowAllMoves { get { return true; } }
		
		[Constructable]
		public King() : base( AIType.AI_Melee, FightMode.Aggressor, 20, 1, 0.2, 0.4 )
		{
			Name = "Arthur";
			Title = "the King";
			Body = 0x190;
			CantWalk = true;
			Hue = Utility.RandomSkinHue();
			SpeechHue = 43;
			Blessed = true;
			
			SetStr( 25, 50 );
			SetDex( 41, 45 );
			SetInt( 21, 35 );
			SetHits( 188, 208 );
			
			Fame = 15000;
			Karma = 15000;

			Item wand = new HealWand();
			wand.Name = "Zezlo";
			wand.Movable = false;
			AddItem( wand );

			Item suit = new Robe();
			suit.ItemID = 8258;
			suit.Name = "Kralovsky oblek";
			suit.Movable = false;
			AddItem( suit );
		}

		public King( Serial serial ) : base( serial )
		{
		}

		public override void GetContextMenuEntries(Mobile m, System.Collections.Generic.List<ContextMenuEntry> list) //added for Runuo 2.0
		{
			base.GetContextMenuEntries( m, list );
			list.Add( new KingEntry( m, this ) );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}

		public class KingEntry : ContextMenuEntry
		{
			private Mobile m_Mobile;
			private Mobile m_Giver;
			
			public KingEntry( Mobile m, Mobile giver ) : base( 6146, 3 )
			{
				m_Mobile = m;
				m_Giver = giver;
			}

			public override void OnClick()
			{
				if( !( m_Mobile is PlayerMobile ) )
					return;
				
				PlayerMobile mobile = (PlayerMobile) m_Mobile;

				if (XmlAttach.FindAttachment(m_Mobile, typeof(HlavniQuest)) == null)
				{
					if ( ! m_Mobile.HasGump( typeof( KingGump ) ) )
					{
						m_Mobile.SendGump( new KingGump( m_Giver ));
					}
				}
				else
				{
					HlavniQuest qatt = (HlavniQuest)XmlAttach.FindAttachment(m_Mobile,typeof(HlavniQuest));
					
					if ( qatt.InProgress && !qatt.KilledDragon )
					{
						QuestJar x = m_Mobile.Backpack.FindItemByType( typeof(QuestJar) ) as QuestJar;
						if ( x != null && x.isFull && x.Owner == m_Mobile )
							m_Giver.Say("Vyborne! Nadobku uz mas plnou, nyni jiz zbyva jen porazit draka a zahnat ho zpet za barieru!");
						else if ( x != null && !x.isFull && x.Owner == m_Mobile )
							m_Giver.Say("Napln nadobku, at se co nejdrive muzes vydat do boje s drakem Auberonem!");
						else if ( x == null )
							m_Giver.Say("Kde mas svoji nadobku? Bez ni se k drakovi nikdy nedostanes!");
					}
					else if ( !qatt.InProgress && !qatt.KilledDragon && qatt.NextRepeat < DateTime.Now )
					{
						if ( ! m_Mobile.HasGump( typeof( KingGump ) ) )
						{
							m_Mobile.SendGump( new KingGump( m_Giver ));
						}
					}
					else if ( !qatt.InProgress && qatt.NextRepeat > DateTime.Now )
					{
                  m_Mobile.SendMessage( 0x35, "Dalsi nadobku dostanes {0:g}", qatt.NextRepeat );
						m_Giver.Say("Jeste si chvili odpocin!");
               }
					else if ( qatt.InProgress && qatt.KilledDragon )
					{
						if ( ! m_Mobile.HasGump( typeof( KingGumpEnd ) ) )
						{
							m_Mobile.SendGump( new KingGumpEnd( m_Giver, m_Mobile ));
							m_Mobile.SendMessage( 0x35, "Pocet predeslych dokonceni questu: " + qatt.Count.ToString() );
						}
					}
					else
						m_Giver.Say("Hmmm, nevim ze bych si s nekym domlouval schuzku.");
				}
			}
		}
	}
}
